/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UDynLink.cpp,v 1.5 2000/01/07 07:46:57 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "UDynLink.h"

_USING_PGP

_UNNAMED_BEGIN

// Types

typedef long (_stdcall * BroadcastSystemMessageType)(DWORD, LPDWORD, 
	UINT, WPARAM, LPARAM);

typedef BOOL (_stdcall * GetDiskFreeSpaceExType)(LPCTSTR, 
	PULARGE_INTEGER, PULARGE_INTEGER, PULARGE_INTEGER);

typedef DWORD (_stdcall * Win95_NetShareGetInfoType)(const char FAR *, 
	const char FAR *, short, char FAR *, unsigned short, 
	unsigned short FAR *);
typedef DWORD (_stdcall * Win95_WNetCloseEnumType)(HANDLE);
typedef DWORD (_stdcall * Win95_WNetEnumResourceType)(HANDLE, LPDWORD, 
	LPVOID, LPDWORD);
typedef DWORD (_stdcall * Win95_WNetOpenEnumType)(DWORD, DWORD, DWORD, 
	LPNETRESOURCE, LPHANDLE);

typedef VOID (_stdcall * WinNT_FormatExType)(PWCHAR, DWORD, PWCHAR, 
	PWCHAR, BOOL, DWORD, UDynLink::PFMIFSCALLBACK);
typedef DWORD (_stdcall * WinNT_NetApiBufferFreeType)(LPVOID);
typedef DWORD (_stdcall * WinNT_NetShareGetInfoType)(LPWSTR, LPWSTR, 
	DWORD, LPBYTE *);
typedef DWORD (_stdcall * WinNT_WNetGetUniversalNameType)(LPCTSTR,
	DWORD, LPVOID, LPDWORD);

typedef BOOL (_stdcall * WinNT_OpenProcessTokenType)(HANDLE, DWORD, PHANDLE);
typedef BOOL (_stdcall * WinNT_OpenThreadTokenType)(HANDLE, DWORD, BOOL, 
	PHANDLE);

typedef BOOL (_stdcall * WinNT_GetTokenInformationType)(HANDLE, 
	TOKEN_INFORMATION_CLASS, LPVOID, DWORD, PDWORD);

typedef BOOL (_stdcall * WinNT_AllocateAndInitializeSidType)(
	PSID_IDENTIFIER_AUTHORITY, BYTE, DWORD, DWORD, DWORD, DWORD, DWORD, 
	DWORD, DWORD, DWORD, PSID *);

typedef BOOL (_stdcall * WinNT_EqualSidType)(PSID, PSID);
typedef PVOID (_stdcall * WinNT_FreeSidType)(PSID);

typedef BOOL (_stdcall * Win2k_GetVolumeNameForVolumeMountPointType)(
	LPCTSTR, LPTSTR, DWORD);
typedef BOOL (_stdcall * Win2k_GetVolumePathNameType)(LPCTSTR, LPTSTR, DWORD);
typedef BOOL (_stdcall * Win2k_SetVolumeMountPointType)(LPCTSTR, LPCTSTR);
typedef BOOL (_stdcall * Win2k_DeleteVolumeMountPointType)(LPCTSTR);


// Static variables

HINSTANCE	Advapi32Handle;
HINSTANCE	FmifsHandle;
HINSTANCE	Kernel32Handle;
HINSTANCE	MprHandle;
HINSTANCE	NetApi32Handle;
HINSTANCE	SvrApiHandle;
HINSTANCE	User32Handle;

BroadcastSystemMessageType	BroadcastSystemMessageAddr;
GetDiskFreeSpaceExType		GetDiskFreeSpaceExAddr;

Win95_NetShareGetInfoType		Win95_NetShareGetInfoAddr;
Win95_WNetCloseEnumType			Win95_WNetCloseEnumAddr;
Win95_WNetEnumResourceType		Win95_WNetEnumResourceAddr;
Win95_WNetOpenEnumType			Win95_WNetOpenEnumAddr;

WinNT_FormatExType				WinNT_FormatExAddr;
WinNT_NetApiBufferFreeType		WinNT_NetApiBufferFreeAddr;
WinNT_NetShareGetInfoType		WinNT_NetShareGetInfoAddr;
WinNT_WNetGetUniversalNameType	WinNT_WNetGetUniversalNameAddr;

WinNT_OpenProcessTokenType		WinNT_OpenProcessTokenAddr;
WinNT_OpenThreadTokenType		WinNT_OpenThreadTokenAddr;

WinNT_GetTokenInformationType	WinNT_GetTokenInformationAddr;

WinNT_AllocateAndInitializeSidType	WinNT_AllocateAndInitializeSidAddr;
WinNT_EqualSidType					WinNT_EqualSidAddr;
WinNT_FreeSidType					WinNT_FreeSidAddr;

Win2k_GetVolumeNameForVolumeMountPointType 
	Win2k_GetVolumeNameForVolumeMountPointAddr;

Win2k_GetVolumePathNameType			Win2k_GetVolumePathNameAddr;
Win2k_SetVolumeMountPointType		Win2k_SetVolumeMountPointAddr;
Win2k_DeleteVolumeMountPointType	Win2k_DeleteVolumeMountPointAddr;


// Static functions

void 
LoadAdvapi32()
{
	if (IsNull(Advapi32Handle))
	{
		Advapi32Handle = LoadLibrary("advapi32.dll");

		if (IsNull(Advapi32Handle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadFmifs()
{
	if (IsNull(FmifsHandle))
	{
		FmifsHandle = LoadLibrary("fmifs.dll");

		if (IsNull(FmifsHandle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadKernel32()
{
	if (IsNull(Kernel32Handle))
	{
		Kernel32Handle = LoadLibrary("kernel32.dll");

		if (IsNull(Kernel32Handle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadMpr()
{
	if (IsNull(MprHandle))
	{
		MprHandle = LoadLibrary("mpr.dll");

		if (IsNull(MprHandle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadNetApi32()
{
	if (IsNull(Kernel32Handle))
	{
		NetApi32Handle = LoadLibrary("netapi32.dll");

		if (IsNull(NetApi32Handle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadSvrApi()
{
	if (IsNull(Kernel32Handle))
	{
		SvrApiHandle = LoadLibrary("svrapi.dll");

		if (IsNull(SvrApiHandle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

void 
LoadUser32()
{
	if (IsNull(Kernel32Handle))
	{
		User32Handle = LoadLibrary("user32.dll");

		if (IsNull(User32Handle))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}
}

_UNNAMED_END

// Exported functions

long 
UDynLink::BroadcastSystemMessage(
	DWORD	dwFlags, 
	LPDWORD	lpdwRecipients, 
	UINT	uiMessage, 
	WPARAM	wParam, 
	LPARAM	lParam)
{
	if (IsNull(BroadcastSystemMessageAddr))
	{
		LoadUser32();

		BroadcastSystemMessageAddr = 
			reinterpret_cast<BroadcastSystemMessageType>(
			GetProcAddress(User32Handle, "BroadcastSystemMessage"));

		if (IsNull(BroadcastSystemMessageAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	long	result	= BroadcastSystemMessageAddr(dwFlags, 
		lpdwRecipients, uiMessage, wParam, lParam);

	return result;
}

BOOL 
UDynLink::GetDiskFreeSpaceEx(
	LPCTSTR			lpDirectoryName, 
	PULARGE_INTEGER	lpFreeBytesAvailableToCaller, 
	PULARGE_INTEGER	lpTotalNumberOfBytes, 
	PULARGE_INTEGER	lpTotalNumberOfFreeBytes)
{
	if (IsNull(GetDiskFreeSpaceExAddr))
	{
		LoadKernel32();

	#if defined(_UNICODE)
		GetDiskFreeSpaceExAddr = reinterpret_cast<GetDiskFreeSpaceExType>(
			GetProcAddress(Kernel32Handle, "GetDiskFreeSpaceExW"));
	#else	// !_UNICODE
		GetDiskFreeSpaceExAddr = reinterpret_cast<GetDiskFreeSpaceExType>(
			GetProcAddress(Kernel32Handle, "GetDiskFreeSpaceExA"));
	#endif	// _UNICODE

		if (IsNull(GetDiskFreeSpaceExAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	BOOL	result	= GetDiskFreeSpaceExAddr(lpDirectoryName, 
		lpFreeBytesAvailableToCaller, lpTotalNumberOfBytes, 
		lpTotalNumberOfFreeBytes);

	return result;
}

DWORD 
UDynLink::Win95_NetShareGetInfo(
	const char FAR		*pszServer, 
	const char FAR		*pszNetName, 
	short				sLevel, 
	char FAR			*pbBuffer, 
	unsigned short		cbBuffer, 
	unsigned short FAR	*pcbTotalAvail)
{
	if (IsNull(Win95_NetShareGetInfoAddr))
	{
		LoadSvrApi();

		Win95_NetShareGetInfoAddr = reinterpret_cast<
			Win95_NetShareGetInfoType>(GetProcAddress(SvrApiHandle, 
			"NetShareGetInfo"));

		if (IsNull(Win95_NetShareGetInfoAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win95_NetShareGetInfoAddr(pszServer, pszNetName, sLevel, 
		pbBuffer, cbBuffer, pcbTotalAvail);
}

DWORD 
UDynLink::Win95_WNetCloseEnum(HANDLE hEnum)
{
	if (IsNull(Win95_WNetCloseEnumAddr))
	{
		LoadMpr();

		Win95_WNetCloseEnumAddr = reinterpret_cast<Win95_WNetCloseEnumType>(
				GetProcAddress(MprHandle, "WNetCloseEnum"));

		if (IsNull(Win95_WNetCloseEnumAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win95_WNetCloseEnumAddr(hEnum);
}

DWORD 
UDynLink::Win95_WNetEnumResource(
	HANDLE	hEnum, 
	LPDWORD	lpcCount, 
	LPVOID	lpBuffer, 
	LPDWORD	lpBufferSize)
{
	if (IsNull(Win95_WNetEnumResourceAddr))
	{
		LoadMpr();

	#if defined(_UNICODE)
		Win95_WNetEnumResourceAddr = 
			reinterpret_cast<Win95_WNetEnumResourceType>(
				GetProcAddress(MprHandle, "WNetEnumResourceW"));
	#else	// !_UNICODE
		Win95_WNetEnumResourceAddr = 
			reinterpret_cast<Win95_WNetEnumResourceType>(
				GetProcAddress(MprHandle, "WNetEnumResourceA"));
	#endif	// _UNICODE

		if (IsNull(Win95_WNetEnumResourceAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win95_WNetEnumResourceAddr(hEnum, lpcCount, lpBuffer, 
		lpBufferSize);
}

// Win95_WNetGetUniversalName implements a hack under Windows95 that
// simulates the non-working WNetGetUniversalName (from KB Article ID:
// Q131416).

BOOL 
UDynLink::Win95_WNetGetUniversalName(LPCSTR szDrive, LPTSTR szUniv)
{
	// get the local drive letter
	char	chLocal = toupper(szDrive[0]);

	// cursory validation
	if (chLocal < 'A' || chLocal > 'Z')
		return FALSE;

	if (szDrive[1] != ':' || szDrive[2] != '\\')
		return FALSE;

	HANDLE	hEnum;
	DWORD	dwResult	= Win95_WNetOpenEnum(RESOURCE_CONNECTED, 
		RESOURCETYPE_DISK, 0, NULL, &hEnum);

	if (dwResult != NO_ERROR)
		return FALSE;

	// request all available entries
	const int	 c_cEntries   = 0xFFFFFFFF;
	// start with a reasonable buffer size
	DWORD		 cbBuffer	  = 50 * sizeof(NETRESOURCE);
	NETRESOURCE	*pNetResource = static_cast<NETRESOURCE *>(malloc(cbBuffer));

	BOOL	fResult	= FALSE;

	while (TRUE)
	{
		DWORD	dwSize	= cbBuffer,
		cEntries = c_cEntries;

		dwResult = Win95_WNetEnumResource(hEnum, &cEntries, pNetResource, 
			&dwSize);

		if (dwResult == ERROR_MORE_DATA)
		{
			// the buffer was too small, enlarge
			cbBuffer = dwSize;
			pNetResource = static_cast<NETRESOURCE*>(
				realloc(pNetResource, cbBuffer));
			continue;
		}

		if (dwResult != NO_ERROR)
			goto done;

		// search for the specified drive letter
		for (int i = 0; i < static_cast<int>(cEntries); i++)
			if (pNetResource[i].lpLocalName &&
				chLocal == toupper(pNetResource[i].lpLocalName[0]))
			{
				// match
				fResult = TRUE;

				// build a UNC name
				strcpy(szUniv, pNetResource[i].lpRemoteName);
				strcat(szUniv, szDrive + 2);
				_strupr(szUniv);
				goto done;
			}
		}

done:
	// cleanup
	Win95_WNetCloseEnum(hEnum);
	free(pNetResource);

	return fResult;
}

DWORD 
UDynLink::Win95_WNetOpenEnum(
	DWORD dwScope, 
	DWORD dwType, 
	DWORD dwUsage, 
	LPNETRESOURCE lpNetResource, 
	LPHANDLE lphEnum)
{
	if (IsNull(Win95_WNetOpenEnumAddr))
	{
		LoadMpr();

	#if defined(_UNICODE)
		Win95_WNetOpenEnumAddr = reinterpret_cast<Win95_WNetOpenEnumType>(
				GetProcAddress(MprHandle, "WNetOpenEnumW"));
	#else	// !_UNICODE
		Win95_WNetOpenEnumAddr = reinterpret_cast<Win95_WNetOpenEnumType>(
				GetProcAddress(MprHandle, "WNetOpenEnumA"));
	#endif	// _UNICODE

		if (IsNull(Win95_WNetOpenEnumAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win95_WNetOpenEnumAddr(dwScope, dwType, dwUsage, lpNetResource, 
		lphEnum);
}

VOID 
UDynLink::WinNT_FormatEx(
	PWCHAR			driveRoot, 
	DWORD			mediaFlag, 
	PWCHAR			format, 
	PWCHAR			label, 
	BOOL			quickFormat, 
	DWORD			clusterSize, 
	PFMIFSCALLBACK	callback)
{
	if (IsNull(WinNT_FormatExAddr))
	{
		LoadFmifs();

		WinNT_FormatExAddr = 
			reinterpret_cast<WinNT_FormatExType>(
			GetProcAddress(FmifsHandle, "FormatEx"));

		if (IsNull(WinNT_FormatExAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	WinNT_FormatExAddr(driveRoot, mediaFlag, format, label, quickFormat, 
		clusterSize, callback);
}

DWORD 
UDynLink::WinNT_NetApiBufferFree(LPVOID Buffer)
{
	if (IsNull(WinNT_NetApiBufferFreeAddr))
	{
		LoadNetApi32();

		WinNT_NetApiBufferFreeAddr = 
			reinterpret_cast<WinNT_NetApiBufferFreeType>(
			GetProcAddress(NetApi32Handle, "NetApiBufferFree"));

		if (IsNull(WinNT_NetApiBufferFreeAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_NetApiBufferFreeAddr(Buffer);
}

DWORD 
UDynLink::WinNT_NetShareGetInfo(
	LPWSTR	servername, 
	LPWSTR	netname, 
	DWORD	level, 
	LPBYTE	*bufptr)
{
	if (IsNull(WinNT_NetShareGetInfoAddr))
	{
		LoadNetApi32();

		WinNT_NetShareGetInfoAddr = reinterpret_cast<
			WinNT_NetShareGetInfoType>(GetProcAddress(NetApi32Handle, 
			"NetShareGetInfo"));

		if (IsNull(WinNT_NetShareGetInfoAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_NetShareGetInfoAddr(servername, netname, level, bufptr);
}

DWORD 
UDynLink::WinNT_WNetGetUniversalName(
	LPCTSTR	lpLocalPath, 
	DWORD	dwInfoLevel, 
	LPVOID	lpBuffer, 
	LPDWORD	lpBufferSize)
{
	if (IsNull(WinNT_WNetGetUniversalNameAddr))
	{
		LoadMpr();

	#if defined(_UNICODE)
		WinNT_WNetGetUniversalNameAddr = 
			reinterpret_cast<WinNT_WNetGetUniversalNameType>(
				GetProcAddress(MprHandle, "WNetGetUniversalNameW"));
	#else	// !_UNICODE
		WinNT_WNetGetUniversalNameAddr = 
			reinterpret_cast<WinNT_WNetGetUniversalNameType>(
				GetProcAddress(MprHandle, "WNetGetUniversalNameA"));
	#endif	// _UNICODE

		if (IsNull(WinNT_WNetGetUniversalNameAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_WNetGetUniversalNameAddr(lpLocalPath, dwInfoLevel, 
		lpBuffer, lpBufferSize);
}

BOOL 
UDynLink::WinNT_OpenProcessToken(
	HANDLE	ProcessHandle, 
	DWORD	DesiredAccess, 
	PHANDLE	TokenHandle)
{
	if (IsNull(WinNT_OpenProcessTokenAddr))
	{
		LoadAdvapi32();

		WinNT_OpenProcessTokenAddr = 
			reinterpret_cast<WinNT_OpenProcessTokenType>(
			GetProcAddress(Advapi32Handle, "OpenProcessToken"));

		if (IsNull(WinNT_OpenProcessTokenAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_OpenProcessTokenAddr(ProcessHandle, DesiredAccess, 
		TokenHandle);
}

BOOL 
UDynLink::WinNT_OpenThreadToken(
	HANDLE	ThreadHandle, 
	DWORD	DesiredAccess, 
	BOOL	OpenAsSelf, 
	PHANDLE	TokenHandle)
{
	if (IsNull(WinNT_OpenThreadTokenAddr))
	{
		LoadAdvapi32();

		WinNT_OpenThreadTokenAddr = 
			reinterpret_cast<WinNT_OpenThreadTokenType>(
			GetProcAddress(Advapi32Handle, "OpenThreadToken"));

		if (IsNull(WinNT_OpenThreadTokenAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_OpenThreadTokenAddr(ThreadHandle, DesiredAccess, 
		OpenAsSelf, TokenHandle);
}

BOOL 
UDynLink::WinNT_GetTokenInformation(
	HANDLE	TokenHandle, 
	TOKEN_INFORMATION_CLASS	TokenInformationClass, 
	LPVOID	TokenInformation, 
	DWORD	TokenInformationLength, 
	PDWORD	ReturnLength)
{
	if (IsNull(WinNT_GetTokenInformationAddr))
	{
		LoadAdvapi32();

		WinNT_GetTokenInformationAddr = 
			reinterpret_cast<WinNT_GetTokenInformationType>(
			GetProcAddress(Advapi32Handle, "GetTokenInformation"));

		if (IsNull(WinNT_GetTokenInformationAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_GetTokenInformationAddr(TokenHandle, TokenInformationClass, 
		TokenInformation, TokenInformationLength, ReturnLength);
}

BOOL 
UDynLink::WinNT_AllocateAndInitializeSid(
	PSID_IDENTIFIER_AUTHORITY	pIdentifierAuthority, 
	BYTE	nSubAuthorityCount, 
	DWORD	nSubAuthority0, 
	DWORD	nSubAuthority1, 
	DWORD	nSubAuthority2, 
	DWORD	nSubAuthority3, 
	DWORD	nSubAuthority4, 
	DWORD	nSubAuthority5, 
	DWORD	nSubAuthority6, 
	DWORD	nSubAuthority7, 
	PSID	*pSid)
{
	if (IsNull(WinNT_AllocateAndInitializeSidAddr))
	{
		LoadAdvapi32();

		WinNT_AllocateAndInitializeSidAddr = 
			reinterpret_cast<WinNT_AllocateAndInitializeSidType>(
			GetProcAddress(Advapi32Handle, "AllocateAndInitializeSid"));

		if (IsNull(WinNT_AllocateAndInitializeSidAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_AllocateAndInitializeSidAddr(pIdentifierAuthority, 
		nSubAuthorityCount, nSubAuthority0, nSubAuthority1, nSubAuthority2, 
		nSubAuthority3, nSubAuthority4, nSubAuthority5, nSubAuthority6, 
		nSubAuthority7, pSid);
}

BOOL 
UDynLink::WinNT_EqualSid(PSID pSid1, PSID pSid2)
{
	if (IsNull(WinNT_EqualSidAddr))
	{
		LoadAdvapi32();

		WinNT_EqualSidAddr = 
			reinterpret_cast<WinNT_EqualSidType>(
			GetProcAddress(Advapi32Handle, "EqualSid"));

		if (IsNull(WinNT_EqualSidAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_EqualSidAddr(pSid1, pSid2);
}

PVOID 
UDynLink::WinNT_FreeSid(PSID pSid)
{
	if (IsNull(WinNT_FreeSidAddr))
	{
		LoadAdvapi32();

		WinNT_FreeSidAddr = 
			reinterpret_cast<WinNT_FreeSidType>(
			GetProcAddress(Advapi32Handle, "FreeSid"));

		if (IsNull(WinNT_FreeSidAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return WinNT_FreeSidAddr(pSid);
}

BOOL 
UDynLink::Win2k_GetVolumeNameForVolumeMountPoint(
	LPCTSTR	lpszVolumeMountPoint, 
	LPTSTR	lpszVolumeName, 
	DWORD	cchBufferLength)
{
	if (IsNull(Win2k_GetVolumeNameForVolumeMountPointAddr))
	{
		LoadKernel32();

	#if defined(_UNICODE)
		Win2k_GetVolumeNameForVolumeMountPointAddr = 
			reinterpret_cast<Win2k_GetVolumeNameForVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, 
				"GetVolumeNameForVolumeMountPointW"));
	#else	// !_UNICODE
		Win2k_GetVolumeNameForVolumeMountPointAddr = 
			reinterpret_cast<Win2k_GetVolumeNameForVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, 
				"GetVolumeNameForVolumeMountPointA"));
	#endif	// _UNICODE

		if (IsNull(Win2k_GetVolumeNameForVolumeMountPointAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win2k_GetVolumeNameForVolumeMountPointAddr(lpszVolumeMountPoint, 
		lpszVolumeName, cchBufferLength);
}

BOOL 
UDynLink::Win2k_GetVolumePathName(
	LPCTSTR	lpszFileName, 
	LPTSTR	lpszVolumePathName, 
	DWORD	cchBufferLength)
{
	if (IsNull(Win2k_GetVolumePathNameAddr))
	{
		LoadKernel32();

	#if defined(_UNICODE)
		Win2k_GetVolumePathNameAddr = 
			reinterpret_cast<Win2k_GetVolumePathNameType>(
				GetProcAddress(Kernel32Handle, "GetVolumePathNameW"));
	#else	// !_UNICODE
		Win2k_GetVolumePathNameAddr = 
			reinterpret_cast<Win2k_GetVolumePathNameType>(
				GetProcAddress(Kernel32Handle, "GetVolumePathNameA"));
	#endif	// _UNICODE

		if (IsNull(Win2k_GetVolumePathNameAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win2k_GetVolumePathNameAddr(lpszFileName, lpszVolumePathName, 
		cchBufferLength);
}

BOOL 
UDynLink::Win2k_SetVolumeMountPoint(
	LPCTSTR	lpszVolumeMountPoint, 
	LPCTSTR	lpszVolumeName)
{
	if (IsNull(Win2k_SetVolumeMountPointAddr))
	{
		LoadKernel32();

	#if defined(_UNICODE)
		Win2k_SetVolumeMountPointAddr = 
			reinterpret_cast<Win2k_SetVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, "SetVolumeMountPointW"));
	#else	// !_UNICODE
		Win2k_SetVolumeMountPointAddr = 
			reinterpret_cast<Win2k_SetVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, "SetVolumeMountPointA"));
	#endif	// _UNICODE

		if (IsNull(Win2k_SetVolumeMountPointAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win2k_SetVolumeMountPointAddr(lpszVolumeMountPoint, 
		lpszVolumeName);
}

BOOL 
UDynLink::Win2k_DeleteVolumeMountPoint(LPCTSTR lpszVolumeMountPoint)
{
	if (IsNull(Win2k_DeleteVolumeMountPointAddr))
	{
		LoadKernel32();

	#if defined(_UNICODE)
		Win2k_DeleteVolumeMountPointAddr = 
			reinterpret_cast<Win2k_DeleteVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, "DeleteVolumeMountPointW"));
	#else	// !_UNICODE
		Win2k_DeleteVolumeMountPointAddr = 
			reinterpret_cast<Win2k_DeleteVolumeMountPointType>(
				GetProcAddress(Kernel32Handle, "DeleteVolumeMountPointA"));
	#endif	// _UNICODE

		if (IsNull(Win2k_DeleteVolumeMountPointAddr))
			THROW_ERRORS(kPGPError_Win32DllOpFailed, GetLastError());
	}

	return Win2k_DeleteVolumeMountPointAddr(lpszVolumeMountPoint);
}
